document.addEventListener('DOMContentLoaded', fetchEstoque);

async function fetchEstoque() {
    try {
        // Solicitação para o backend PHP
        const response = await fetch('https://vitthost.com.br/estoque/estoque.php');

        if (!response.ok) {
            throw new Error(`Erro na solicitação: ${response.status} ${response.statusText}`);
        }

        // Converte a resposta para JSON
        const data = await response.json();
        
        // Verifica se a quantidade existe e exibe na página
        if (data && data.qty !== undefined) {
            document.getElementById('estoque-quantity').textContent = `Quantidade em estoque: ${data.qty}`;
        } else {
            document.getElementById('estoque-quantity').textContent = 'Quantidade não disponível';
        }
    } catch (error) {
        // Exibe uma mensagem de erro na página
        document.getElementById('estoque-quantity').textContent = `Erro: ${error.message}`;
        console.error(error);
    }
}
